/* eslint-disable max-len */
define([
    'marionette',
    'modules/new-appointment-wizard/wizard-section-view',
    'json!modules/community-care-request/new-appointment-request-question/service-distance-selection/community-care-service-distance.json',
],
function(Marionette, WizardSectionView, metadata) {
    'use strict';

    return WizardSectionView.extend({
        modelEvents: {
            'change:travelBurden': 'handleTravelChange',
            'change:distanceEligible': 'handleEligibiltyChange',
        },
        initialize: function(options) {
            var sectionName = 'travel-section';
            this._initializeSection(options, sectionName, metadata, options.model.get('steps')[1]);
            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
        },
        hideElement: function(identifier) {
            this.$el.find(identifier).hide();
        },
        onRender: function() {
            if (!this.model.get('distanceEligible') || this.model.get('distanceEligible') === 'yes') {
                this.hideElement('.travel-distance');
                this.hideElement('.unusual-travel');
            } else if (this.model.get('travelBurden') === 'yes') {
                this.hideElement('.unusual-travel');
            }
        },
        handleEligibiltyChange: function (model, value) {
            if (value === 'no') {
                this.$el.find('.travel-distance').show();
            } else {
                this.unsetTravel();
            }
        },
        handleTravelChange: function(model, value) {
            if (value === 'no') {
                this.$el.find('.unusual-travel').show();
            } else {
                this.unsetUnsualTravel();
            }
        },
        unsetTravel: function() {
            var travelModel = this.collection.get('travelBurden');
            this.hideElement('.travel-distance');
            travelModel.unset('value');
            travelModel.set('selected', '');
            this.model.unset('travelBurden');
            this.children.findByModel(travelModel).render();
            this.unsetUnsualTravel();
        },
        unsetUnsualTravel: function() {
            var unusualTravelModel;

            this.hideElement('.unusual-travel');
            // clear out all the ui and wizard model data for unusual
            unusualTravelModel = this.collection.get('unusualTravelBurden');
            unusualTravelModel.unset('value');
            unusualTravelModel.set('selected', '');
            this.model.unset('unusualTravelBurden');
            // force re-render of unusual travel
            this.children.findByModel(unusualTravelModel).render();
        },

    });
});
